<?php
/**
 * @Template: manual-import-template.php.
 * @since: 1.0.0
 * author: KP
 * @descriptions:
 * @create: 12/19/2018
 */
?>

<div class="lqd-manual-import-layout lqd-m-hidden" style="display: none">
    <div class="lqd-contain">

        <div class="lqd-loading" style="display: none">
            <span class="lqd-pinner"><span class="fa fa-spinner fa-spin"></span></span>
        </div>
        <span class="dashicons dashicons-dismiss"></span>
        <div class="lqd-contain-wrap">
            <div class="lqd-tabs-head">
                <div class="tabs-demos lqd-mi-active" data-id="select-demo">
                    <span><?php esc_html_e('Select Demo', LQD_TEXT_DOMAIN) ?></span>
                </div>
                <div class="tabs-demos"
                     data-id="attachments">
                    <span><?php esc_html_e('Download Attachment', LQD_TEXT_DOMAIN) ?></span>
                </div>
            </div>
            <div class="lqd-tabs-content">
                <div class="tabs-contents lqd-mi-demo-list" id="select-demo">
                    <?php
                    if (!empty($demo_list)):
                        foreach ($demo_list as $demo):
                            $file_demo_info = $path . $demo . '/demo-info.json';
                            $demo_installed = $current_demo_installed === $demo ? true : false;
                            if (file_exists($file_demo_info)):
                                $info_demo = json_decode(file_get_contents($file_demo_info), true);
                                $link = "#";
                                if (file_exists($path . $demo . '/options.json')) {
                                    $options = json_decode(file_get_contents($path . $demo . '/options.json'), true);
                                    $link = $options['attachment'];
                                }
                                ?>
                                <div class="lqd-mi-demo-item">
                                    <div class="lqd-mi-item-inner">
                                        <div class="lqd-mi-image">
                                            <img src="<?php echo $url . $demo . '/screenshot.png' ?>" alt="">
                                            <div class="lqd-mi-preview">
                                                <h4 class="lqd-mi-demo-title"><?php echo esc_attr($info_demo['name']) ?></h4>
                                                <a class="lqd-mi-select" href="#"
                                                   data-attachment="<?php echo esc_url($link) ?>" data-demo="<?php echo esc_attr($demo) ?>">
                                                    <span><?php esc_html_e('Select', LQD_TEXT_DOMAIN) ?></span>
                                                </a>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            <?php
                            endif;
                        endforeach;
                    else:
                        ?>
                        <div class="lqd-ie-demo-empty">
                            <span class="dashicons dashicons-warning"></span>
                            <h4 class="lqd-ie-notice-empty"><?php echo esc_html__('Demos data is empty') ?></h4>
                        </div>
                    <?php
                    endif;
                    ?>
                </div>
                <div class="tabs-contents" id="attachments">
                    <div class="lqd-mi-demo-item-selected">
                        <div class="lqd-mi-item-inner">
                            <div class="lqd-mi-image lqd-mi-image-selected">
                                <img src="<?php echo lqd_ie()->assets_url . '/lqd-ie.jpg' ?>" alt="">
                                <div class="lqd-mi-preview">
                                    <h4 class="lqd-mi-demo-title-selected"></h4>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="lqd-mi-download-att">
                        <div class="lqd-mi-dl-step step-1">
                            <h4><?php echo esc_html__('Step 1:', LQD_TEXT_DOMAIN) ?></h4>
                            <button id="lqd-download-attachment-btn"
                                    data-attachment="#"><?php echo esc_html__('Download Attachments File', LQD_TEXT_DOMAIN) ?></button>
                        </div>
                        <div class="lqd-mi-dl-step step-2">
                            <h4><?php echo esc_html__('Step 2:', LQD_TEXT_DOMAIN) ?></h4>
                            <p>Please <b>"<?php esc_html_e("Upload", LQD_TEXT_DOMAIN) ?>
                                    "</b> <?php esc_html_e("and", LQD_TEXT_DOMAIN) ?>
                                <b>"<?php esc_html_e("Unzip", LQD_TEXT_DOMAIN) ?>"</b> file
                                to <b><?php echo wp_upload_dir()['basedir'] ?>/</b></p>
                        </div>
                        <div class="lqd-mi-dl-step step-3">
                            <input type="checkbox" id="lqd-accept-unzip-done" value="lqd-accept">
                            <label for="lqd-accept-unzip-done"><?php esc_html_e("I uploaded and unzipped file", LQD_TEXT_DOMAIN) ?></label>
                        </div>
                        <div class="lqd-mi-dl-step step-4">
                            <button><?php esc_html_e("Import Demo Data", LQD_TEXT_DOMAIN) ?></button>
                            <form method="post" style="display: none">
                                <input type="hidden" name="lqd-ie-id" value="<?php echo esc_attr($demo) ?>">
                                <input type="hidden" name="action" value="lqd-import">
                                <input type="hidden" name="manual_importing" value="true">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>